% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveImages.R
\name{saveObject,ExtImage-method}
\alias{saveObject,ExtImage-method}
\title{Save \code{ExtImage} to disk for \code{alabaster}}
\usage{
\S4method{saveObject}{ExtImage}(x, path, ...)
}
\arguments{
\item{x}{A Bioconductor object of the specified class.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Extra arguments passed to \code{\link{writeImage}}.}
}
\value{
x is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save \code{ExtImage} to disk for \code{alabaster}
}
\examples{
library(SFEData)
fp <- tempfile()
fsave <- file.path(fp, "exi")
x1 <- XeniumOutput(dataset = "v1", file_path = file.path(fp, "xenium1"))
sfe <- readXenium(x1)
bfi <- getImg(sfe)
exi <- toExtImage(bfi)
saveObject(exi, fsave)
exi2 <- readObject(fsave)
unlink(fsave, recursive = TRUE)

}
\seealso{
Other saveObject-SFE-image: 
\code{\link{saveObject,BioFormatsImage-method}},
\code{\link{saveObject,SpatRaster-method}}
}
\concept{saveObject-SFE-image}
