% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveImages.R
\name{saveObject,BioFormatsImage-method}
\alias{saveObject,BioFormatsImage-method}
\title{Save \code{BioFormatsImage} for \code{alabaster}}
\usage{
\S4method{saveObject}{BioFormatsImage}(x, path, ...)
}
\arguments{
\item{x}{A Bioconductor object of the specified class.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Ignored}
}
\value{
x is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
This function copies the original file to a pre-defined location within the
directory that stores the on disk representation of the SFE object for data
sharing. Since \code{BioFormatsImage} is essentially just some metadata in
memory and it never loads the image into memory (once the image is loaded
into memory it becomes \code{ExtImage}), once the original image is moved,
the \code{BioFormatsImage} object will no longer work, which is why the
pre-defined location is important. This function also saves the metadata,
which includes spatial extent and affine transformations.
}
\examples{
library(SFEData)
fp <- tempfile()
fsave <- file.path(fp, "bfi2")
x1 <- XeniumOutput(dataset = "v1", file_path = file.path(fp, "xenium1"))
sfe <- readXenium(x1)
bfi <- getImg(sfe)
saveObject(bfi, fsave)
bfi2 <- readObject(fsave)
unlink(fsave, recursive = TRUE)
}
\seealso{
Other saveObject-SFE-image: 
\code{\link{saveObject,ExtImage-method}},
\code{\link{saveObject,SpatRaster-method}}
}
\concept{saveObject-SFE-image}
