% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readImages.R
\name{readSpatRaster}
\alias{readSpatRaster}
\title{Read \code{SpatRaster} from \code{alabaster} on disk representation}
\usage{
readSpatRaster(path, metadata = NULL, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with a \code{\link[alabaster.base]{saveObject}} method.}

\item{metadata}{Named list containing metadata for the object - most importantly, the \code{type} field that controls dispatch to the correct loading function.
If \code{NULL}, this is automatically read by \code{\link[alabaster.base]{readObjectFile}(path)}.}

\item{...}{Arguments passed to \code{\link[terra]{rast}}, character method.}
}
\value{
A \code{\link{SpatRasterImage}} object for SFE.
}
\description{
Not the same as \code{terra::rast}; here this function also reads the
metadata file.
}
\examples{
library(SFEData)
fp <- tempfile()
fn <- file.path(fp, "vizgen")
d <- VizgenOutput(dataset = "cellpose", file_path = fn)
suppressWarnings(sfe <- readVizgen(d))
img <- getImg(sfe)
class(img)
fsave <- file.path(fp, "img")
saveObject(img, fsave)
img2 <- readObject(fsave)

}
\seealso{
Other readObject-SFE-image: 
\code{\link{readBioFormatsImage}()},
\code{\link{readExtImage}()}
}
\concept{readObject-SFE-image}
