% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigWigFileReference.R
\docType{class}
\name{BigWigFileReference}
\alias{BigWigFileReference}
\alias{BigWigFileReference-class}
\alias{saveObject,BigWigFileReference-method}
\alias{readBigWigFileReference}
\alias{BigWigWrapper}
\alias{BigWigWrapper-class}
\alias{stageObject,BigWigWrapper-method}
\alias{loadBigWigWrapper}
\title{Reference to a bigWig file}
\usage{
BigWigFileReference(path)
}
\arguments{
\item{path}{String containing the path to a bigWig file.}
}
\value{
A BigWigFileReference instance that can be used in \code{\link{stageObject}}.
}
\description{
Reference to a bigWig file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Mocking up a bigWig file.
test_path <- system.file("tests", "test.bw", package = "rtracklayer")

# Creating a BigWigFileReference.
wrapped <- BigWigFileReference(test_path)
wrapped

# Staging the BigWigFileReference.
dir <- tempfile()
saveObject(wrapped, dir)
list.files(dir, recursive=TRUE)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
