% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDataFrameFactor.R
\name{readDataFrameFactor}
\alias{readDataFrameFactor}
\alias{loadDataFrameFactor}
\title{Read a DataFrame factor from disk}
\usage{
readDataFrameFactor(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with the \code{\link{saveObject}} method for \link[S4Vectors]{DataFrameFactor}s.}

\item{metadata}{Named list containing metadata for the object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments to pass to internal \code{\link{altSaveObject}} calls.}
}
\value{
A \link[S4Vectors]{DataFrameFactor} represented by \code{path}.
}
\description{
Read a \link[S4Vectors]{DataFrameFactor} from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
library(S4Vectors)
df <- DataFrame(X=LETTERS[1:5], Y=1:5)
out <- DataFrameFactor(df[sample(5, 100, replace=TRUE),,drop=FALSE])

tmp <- tempfile()
saveObject(out, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,DataFrameFactor-method}"}, for the staging method.
}
\author{
Aaron Lun
}
