% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSimulatedData.R
\name{makeSimulatedData}
\alias{makeSimulatedData}
\title{Make simulated data for airpart}
\usage{
makeSimulatedData(
  mu1 = 2,
  mu2 = 10,
  nct = 4,
  n = 30,
  ngenecl = 50,
  theta = 20,
  ncl = 3,
  p.vec = rep(c(0.2, 0.8, 0.5, 0.5, 0.7, 0.9), each = 2),
  totalClusters = FALSE
)
}
\arguments{
\item{mu1}{low count (typical of "noisy" ratio estimates)}

\item{mu2}{high count}

\item{nct}{number of cell types}

\item{n}{number of cells per cell type}

\item{ngenecl}{number of genes per cluster}

\item{theta}{overdispersion parameter (higher is closer to binomial)}

\item{ncl}{number of gene cluster}

\item{p.vec}{the allelic ratio vector which follows gene cluster order.
(length is nct * ncl)}

\item{totalClusters}{logical, whether cell types should cluster by total
count}
}
\value{
SingleCellExperiment with the following elements as assays
\itemize{
  \item{a1} {allelic count matrix for the numerator/effect allele}
  \item{a2} {allelic count matrix for the denominator/non-effect allele}
  \item{true.ratio} {a matrix of the true probabilities
(allelic ratios) for the cell types}
}
Also \code{x} in the colData is a vector of annotated
cell types in the same order as cells in count matrix
}
\description{
Make simulated data for airpart
}
\examples{
library(SummarizedExperiment)
sce <- makeSimulatedData()
assayNames(sce)
}
