% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusedLasso.R
\name{makeOffByOneAdjMat}
\alias{makeOffByOneAdjMat}
\title{Generating adjancy matrix for neighboring cell states.}
\usage{
makeOffByOneAdjMat(nct)
}
\arguments{
\item{nct}{the number of cell types/states}
}
\description{
To use the Graph-Guided Fused Lasso penalty to only regularize the differences
of coefficients of neighboring areas, suitable for time/spatial analysis.
The adjacency matrix corresponding to the graph needs to be provided.
The elements of this matrix are zero when two levels are not connected, and one when they are adjacent.
}
\details{
If manually input the adjacency matrix, this matrix has to be symmetric and the names of
the cell states should be given as row and column names.
}
\examples{
sce <- makeSimulatedData()
nct <- nlevels(sce$x)
adjmatrix <- makeOffByOneAdjMat(nct)
colnames(adjmatrix) <- rownames(adjmatrix) <- levels(sce$x)

}
