% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingTools.R
\name{vennInLine}
\alias{vennInLine}
\title{Generate Venn diagrams with links for Rmarkdown documents}
\usage{
vennInLine(
  vennlst,
  caplst,
  cex.venn = 1,
  shift.title = FALSE,
  reportDirectory = NULL,
  ...
)
}
\arguments{
\item{vennlst}{The output from \code{makeVenn}.}

\item{caplst}{A list of captions to accompany each Venn diagram.}

\item{cex.venn}{Adjustment parameter for the numbers in the Venn diagram. The default is usually OK.}

\item{shift.title}{Boolean. Should the titles for the Venn diagram be shifted to accommodate long contrast names?}

\item{reportDirectory}{Directory containing the Venn diagram. This is usually set by \code{makeVenn} and for most
people, the default \code{NULL} argument should be used.}

\item{...}{Allows users to pass arbitrary arguments to lower level functions.}
}
\value{
This function returns the required HTML text to generate the Venn diagram
}
\description{
A function to generate Venn diagrams for use within Rmarkdown documents, particularly for
those using the Bioconductor BiocStyle package for formatting.
}
\details{
This function is intended for those who use Rmarkdown documents to present results
and who would like to include Venn diagrams showing the overlap between two to four
contrasts. The Venn diagrams that are generated include links for each cell of the
diagram that will open HTML pages that contain results for the genes that are found
within the cell of the Venn diagram.

Please note that this function is tailored specifically for use within Rmarkdown documents,
particularly those that use the Bioconductor BiocStyle package. The function call should be present in a
code block using the argument results = "asis", because we are directly generating HTML rather
than placing a figure.
}
\seealso{
\code{vennPage} particularly for the example.
}
\author{
James W.  MacDonald \email{jmacdon@u.washington.edu}
}
\keyword{manip}
