% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingTools.R
\name{makeGoTable}
\alias{makeGoTable}
\title{Create HTML tables for Gene Ontology (GO) analyses}
\usage{
makeGoTable(
  fit.table,
  go.summary,
  probe.summary,
  cont.name,
  base.dir = "GO_results",
  extraname = NULL,
  probecol = "PROBEID",
  affy = TRUE
)
}
\arguments{
\item{fit.table}{The output from \link[limma]{topTable}}

\item{go.summary}{The output from running \code{summary} on a \link[GOstats:GOHyperGResult-class]{GOHyperGResults} object.}

\item{probe.summary}{The output from running \link[GOstats]{probeSetSummary} on a \link[GOstats:GOHyperGResult-class]{GOHyperGResults} object.}

\item{cont.name}{The contrast name.}

\item{base.dir}{Character. Where should the HTML tables be generated? Defaults to GO_results.}

\item{extraname}{Character. An extra name that can be used if the contrast name isn't descriptive enough.}

\item{probecol}{The column name in the topTable object that contains probe IDs. Defaults to PROBEID.}

\item{affy}{Boolean. Are the arrays from Affymetrix?}
}
\value{
Returns an \link[ReportingTools:HTMLReportRef-class]{HTMLReportRef} object, which can be used when creating an index page to link
to the results.
}
\description{
This function is used to create HTML tables to present the results from a Gene Ontology (GO) analysis.
}
\details{
After running a GO analysis, it is often useful to first present a table showing the set of significant GO terms
for a given comparison, and then have links to a sub-table for each GO term that shows the genes that were responsible
for the significance of that term. The first table can be generated using the \link[GOstats:GOHyperGResult-class]{summary} function, but
it will not contain the links to the sub-table. The ReportingTools package has functionality to make these tables and sub-tables
automatically, but the default is to include extra glyphs in the main table that are not that useful.

This function is intended to generate a more useful version of the table that one normally gets from ReportingTools.
}
\author{
Jim MacDonald
}
