% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingTools.R
\name{fixHeaderAndGo}
\alias{fixHeaderAndGo}
\title{Fix data.frame header for use with ReportingTools}
\usage{
fixHeaderAndGo(df, affy = TRUE, probecol = "PROBEID")
}
\arguments{
\item{df}{A data.frame}

\item{affy}{Boolean; does the data.frame contain Affymetrix probeset IDs?}

\item{probecol}{Character. The column header containing Affymetrix probeset IDs. Defaults to "PROBEID".}
}
\value{
Returns a list of length two (with names mdf and df). The mdf object can be passed to the
\code{\link[ReportingTools:publish-methods]{publish}} using the .modifyDF argument, and the df object is
input dat.frame with column names corrected to conform to \code{affyLinks} and \code{entrezLinks}, so links
will be generated correctly.
}
\description{
Internal function used to automatically test for columns that can be converted to links
}
\details{
This is an internal function designed to test for the presence of Affymetrix Probeset IDs or
Entrez Gene IDs, and if found, generate a list that can be passed to the ReportingTools publish
function in order to generate hyperlinks. The underlying assumption is that the data will have been
annotated using a Bioconductor annotation package, and thus Affy probeset IDs will have a column header
"PROBEID", and Entrez Gene IDs will have a header "ENTREZID" (or any combination of upper and lowercase letters).
}
\author{
Jim MacDonald
}
