% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/annotateEset.R
\name{annotateEset}
\alias{annotateEset}
\alias{annotateEset,ExpressionSet,ChipDb-method}
\alias{annotateEset,ExpressionSet,AffyGenePDInfo-method}
\alias{annotateEset,ExpressionSet,AffyHTAPDInfo-method}
\alias{annotateEset,ExpressionSet,AffyExonPDInfo-method}
\alias{annotateEset,ExpressionSet,AffyExpressionPDInfo-method}
\alias{annotateEset,ExpressionSet,character-method}
\alias{annotateEset,ExpressionSet,data.frame-method}
\title{Method to annotate ExpressionSets automatically}
\usage{
annotateEset(object, x, ...)

\S4method{annotateEset}{ExpressionSet,ChipDb}(
  object,
  x,
  columns = c("PROBEID", "ENTREZID", "SYMBOL", "GENENAME"),
  multivals = "first"
)

\S4method{annotateEset}{ExpressionSet,AffyGenePDInfo}(object, x, type = "core", ...)

\S4method{annotateEset}{ExpressionSet,AffyHTAPDInfo}(object, x, type = "core", ...)

\S4method{annotateEset}{ExpressionSet,AffyExonPDInfo}(object, x, type = "core", ...)

\S4method{annotateEset}{ExpressionSet,AffyExpressionPDInfo}(object, x, type = "core", ...)

\S4method{annotateEset}{ExpressionSet,character}(object, x, ...)

\S4method{annotateEset}{ExpressionSet,data.frame}(object, x, probecol = NULL, annocols = NULL, ...)
}
\arguments{
\item{object}{An ExpressionSet to which we want to add annotation.}

\item{x}{Either a ChipDb package (e.g., hugene10sttranscriptcluster.db),
or a pdInfoPackage object (e.g., pd.hugene.1.0.st.v1).}

\item{...}{Allow users to pass in arbitrary arguments. Particularly useful for
passing in columns, multivals, and type arguments for methods.}

\item{columns}{For ChipDb method; what annotation data to add. Use the \code{\link[AnnotationDbi]{columns}}
function to see what choices you have. By default we get the ENTREZID, SYMBOL and GENENAME.}

\item{multivals}{For ChipDb method; this is passed to \code{\link[AnnotationDbi]{mapIds}} to control how 1:many
mappings are handled. The default is 'first', which takes just the first result. Other valid
values are 'list' and 'CharacterList', which return all mapped results.}

\item{type}{For pdInfoPackages; either 'core' or 'probeset', corresponding to the 'target' argument
used in the call to \code{\link[oligo]{rma}}.}

\item{probecol}{Column of the data.frame that contains the probeset IDs. Can be either
numeric (the column number) or character (the column header).}

\item{annocols}{Column(x) of the data.frame to use for annotating. Can be a vector of numbers
(which column numbers to use) or a character vector (vector of column names).}
}
\value{
An ExpressionSet that has annotation data added to the featureData slot.
}
\description{
This function fills the featureData slot of the ExpressionSet automatically, which is
then available to downstream methods to provide annotated output. Annotating
results is tedious, and can be surprisingly difficult to get right. By annotating
the data automatically, we remove the tedium and add an extra layer of security
since the resulting ExpressionSet will be tested for validity automatically (e.g., annotation
data match up correctly with the expression data). Current choices for the annotation
data are a ChipDb object (e.g., hugene10sttranscriptcluster.db) or an AffyGenePDInfo
object (e.g., pd.hugene.1.0.st.v1). In the latter case, we use the parsed Affymetrix
annotation csv file to get data. This is only intended for those situations where the
ChipDb package is not available, and in particular is only available for those packages
that contain the parsed annotation csv files (generally, Gene ST arrays, Exon ST arrays and
Clariom/HTA/MTA/RTA arrays).
}
\section{Methods (by class)}{
\itemize{
\item \code{object = ExpressionSet,x = ChipDb}: Annotate an ExpressionSet using a ChipDb package for annotation data.

\item \code{object = ExpressionSet,x = AffyGenePDInfo}: Annotate an ExpressionSet using an AffyGenePDInfo package.

\item \code{object = ExpressionSet,x = AffyHTAPDInfo}: Annotate an ExpressionSet using an AffyHTAPDInfo package.

\item \code{object = ExpressionSet,x = AffyExonPDInfo}: Annotate an ExpressionSet using an AffyExonPDInfo package.

\item \code{object = ExpressionSet,x = AffyExpressionPDInfo}: Annotate an ExpressionSet using an AffyExpressionPDInfo package.

\item \code{object = ExpressionSet,x = character}: Method to capture character input.

\item \code{object = ExpressionSet,x = data.frame}: Annotate an ExpressionSet using a user-supplied data.frame.
}}

\examples{
\dontrun{
dat <- read.celfiles(filenames = list.celfiles())
eset <- rma(dat)
## annotate using ChipDb
eset <- annotateEset(eset, hgu10sttranscriptcluster.db)
## or AffyGenePDInfo
eset <- annotateEset(eset, pd.hugene.1.0.st.v1)
}
}
\author{
James W. MacDonald <jmacdon@u.washington>
}
