% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms2Group.R
\name{ms2Group}
\alias{ms2Group}
\title{group MS/MS precursor masses}
\usage{
ms2Group(adductSpectra = NULL, nCores = NULL, 
maxRtDrift = NULL, 
ms1mzError = 0.1, ms2mzError = 1, dotProdClust = TRUE, minDotProd = 0.8,
fclustMethod = "median", disMetric = "euclidean", compSpecGen = TRUE,
adjPrecursorMZ = TRUE)
}
\arguments{
\item{adductSpectra}{AdductSpec object}

\item{nCores}{numeric the number of cores to use for parallel computation. 
The default is to use 1 core.}

\item{maxRtDrift}{numeric for the maximum rentention time
drift to be considered. Default is 20.}

\item{ms1mzError}{numeric maximum MS1 mass:charge error}

\item{ms2mzError}{numeric maximum MS2 mass:charge error}

\item{dotProdClust}{logical remove previous dot prod clustering results}

\item{minDotProd}{numeric. Minimum mean dot product spectral similarity 
score to keep a spectrum within an MS/MS group (default = 0.8).}

\item{fclustMethod}{method to use for the fclust function}

\item{disMetric}{metric to use for distance in clustering}

\item{compSpecGen}{logical for whether composite spectra generation
is necessary}

\item{adjPrecursorMZ}{logical for precursor mass:charge adjustment}
}
\value{
a list identical to adductSpectra containing an additional list
element:
}
\description{
hierarchically cluster ms/ms precursor scans within and across
samples, according to a m/z and retention time error.
}
