% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00AdductQuantif-class.R
\docType{class}
\name{AdductQuantif-class}
\alias{AdductQuantif-class}
\alias{c,AdductQuantif-method}
\alias{show,c,file.paths,peakQuantTable,AdductQuantif,AdductQuantif-class}
\alias{peakIdData,predIsoDist,targTable,AdductQuantif,AdductQuantif-class}
\alias{c,file.paths,peakQuantTable,peakIdData,AdductQuantif-method}
\alias{predIsoDist,targTable,AdductQuantif-method}
\title{AdductQuantif class 
The AdductQuantif class contains a peak integral matrix,
peak ranges and region of integration, the isotopic distribution identified
for each integrated peak and the target table of peaks integrated.}
\format{An object of class \code{NULL} of length 0.}
\usage{
x
}
\value{
peak integral matrix,
peak ranges and region of integration, the isotopic distribution identified
for each integrated peak and the target table of peaks integrated
and their corresponding MS1 scan isotopic patterns
}
\description{
AdductQuantif class 
The AdductQuantif class contains a peak integral matrix,
peak ranges and region of integration, the isotopic distribution identified
for each integrated peak and the target table of peaks integrated.
}
\section{Slots}{

\describe{
\item{\code{peakQuantTable}}{a matrix containing the peak 
integration results and 
consisting of a row for each peak
identified in each sample (e.g 200 samples
and 50 targets 200 * 50 = 10,000 rows)}

\item{\code{peakIdData}}{list of peak IDs}

\item{\code{predIsoDist}}{list of predicted Iso distances}

\item{\code{targTable}}{dataframe target table}

\item{\code{file.paths}}{character path to file}

\item{\code{Parameters}}{dataframe of specified parameters}
}}

\section{Methods}{

\describe{
\item{c}{\code{signature(object = "AdductQuantif")}: Concatenates the 
spectra information.}
\item{file.paths}{\code{signature(object = "AdductQuantif")}: Accesses the 
file paths.}
\item{peakQuantTable}{\code{signature(object = "AdductQuantif")}: Accesses the 
peak quantification data as a table.}
\item{peakIdData}{\code{signature(object = "AdductQuantif")}: Accesses the 
ID data for the peaks.}
\item{predIsoDist}{\code{signature(object = "AdductQuantif")}: Accesses the 
predicted isotopic distribution.}
\item{targTable}{\code{signature(object = "AdductQuantif")}: Accesses the 
user provided target table.}
}
}

\author{
JL Hayes \email{jlhayes1982@gmail.com}
}
\keyword{datasets}
