% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propDEgenes.R
\name{propdegenescalculation}
\alias{propdegenescalculation}
\title{Estimation of proportion of differentially expressed genes}
\usage{
propdegenescalculation(pValue)
}
\arguments{
\item{pValue}{a vector of p-values}
}
\value{
proportion of differential genes
}
\description{
Estimation of proportion of differentially expressed genes.
 This estimation is based on a histogram of the p-values. More specifically,
  based on the horizontal line representing a uniform distribution 
  based on the p value distribution between 0.5 and 1. This represents
  the hypothetical p value distribution arising just by chance.
 All genes with small p-values above this line reflect
  the expected number of differentially expressed genes not by chance.
}
\examples{
if (require(ALL)){
	data(ALL, package = "ALL")
	ALL <- addGeneInfo(ALL)
	ALL$BTtype <- as.factor(substr(ALL$BT,0,1))
	
	tTestResult <- tTest(ALL, "BTtype")
	histPvalue(tTestResult[,"p"], addLegend = TRUE)
	propDEgenesRes <- propDEgenes(tTestResult[,"p"])
}
}
\seealso{
\code{\link{histPvalue}}
}
\author{
Willem Talloen and Tobias Verbeke
}
