% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{translate_to_hg19}
\alias{translate_to_hg19}
\alias{translate_to_1kG}
\title{Translate chromosome names to the hg19 naming convention}
\usage{
translate_to_hg19(in_dat, in_CHROM.field = "CHROM", in_verbose = FALSE)

translate_to_1kG(in_dat, in_CHROM.field = "chr", in_verbose = FALSE)
}
\arguments{
\item{in_dat}{GRanges object, VRanges object or data frame which carries one
column with chromosome information to be reformatted.}

\item{in_CHROM.field}{String indicating which column of \code{in_dat} carries
the chromosome information}

\item{in_verbose}{Whether verbose or not.}
}
\value{
GRanges object, VRanges object or data frame identical to
  \code{in_dat}, but with the names in the chromosome column replaced (if
  dealing with data frames) or alternatively the seqlevels replaced (if
  dealing with GRanges or VRanges objects).
}
\description{
\code{translate_to_hg19}: In hg19 naming convention, chromosome names start
with the prefix \emph{chr} and the gonosomes are called \emph{X} and
\emph{Y}. If data analysis is performed e.g. with
\code{\link[BSgenome.Hsapiens.UCSC.hg19]{BSgenome.Hsapiens.UCSC.hg19}}, this
naming convention is needed. The inverse transform is done with
\code{\link{translate_to_1kG}}.

\code{translate_to_1kG}: In 1kG, i.e. 1000 genomes naming convention, 
chromosome names have no prefix \emph{chr} and the gonosomes are called 
\emph{23} for \emph{X} and \emph{24} for \emph{Y}. If data analysis is 
performed e.g. with \code{hs37d5.fa}, this naming convention is needed. The
inverse transform is done with \code{\link{translate_to_hg19}}.
}
\examples{
test_df <- data.frame(CHROM=c(1,2,23,24),POS=c(100,120000000,300000,25000),
                      dummy=c("a","b","c","d"))
hg19_df <- translate_to_hg19(test_df, in_CHROM.field = "CHROM")
hg19_df

test_df <- data.frame(CHROM=c(1,2,23,24),POS=c(100,120000000,300000,25000),
                      dummy=c("a","b","c","d"))
hg19_df <- translate_to_hg19(test_df, in_CHROM.field = "CHROM")
onekG_df <- translate_to_1kG(hg19_df, in_CHROM.field = "CHROM")
onekG_df

}
