% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{test_exposureAffected}
\alias{test_exposureAffected}
\title{Test significance of association}
\usage{
test_exposureAffected(
  in_exposure_vector,
  in_affected_PIDs,
  in_mutation_label = NULL,
  in_exposure_label = NULL
)
}
\arguments{
\item{in_exposure_vector}{Named vector of a phenotype (e.g. exposures to a
specific signature)}

\item{in_affected_PIDs}{Character vector of samples affected by some
criterion, e.g. mutations in a pathway as returned by
\code{\link{find_affected_PIDs}}}

\item{in_mutation_label}{If non-NULL, prefix to the mutation status (x-axis
label) in the produced boxplot}

\item{in_exposure_label}{If non-NULL, prefix to the exposures (y-axis label)
in the produced boxplot}
}
\value{
A list with entries: \itemize{ \item \code{current_kruskal}: Kruskal
  test object from testing phenotype against affection \item
  \code{current_boxplot}: Boxplot of phenotype against affection }
}
\description{
Test significance of association between a vector of exposures and a
selection of samples, e.g. those affected by mutations in a pathway as
returned by \code{\link{find_affected_PIDs}}
}
\examples{
 NULL

}
