% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sigs}
\alias{sigs}
\alias{AlexInitialArtif_sig_df}
\alias{AlexInitialArtif_sigInd_df}
\alias{AlexInitialValid_sig_df}
\alias{AlexInitialValid_sigInd_df}
\alias{AlexCosmicValid_sig_df}
\alias{AlexCosmicValid_sigInd_df}
\alias{AlexCosmicArtif_sig_df}
\alias{AlexCosmicArtif_sigInd_df}
\title{Data for mutational signatures}
\source{
\code{AlexInitial}: \url{ftp://ftp.sanger.ac.uk/pub/cancer/AlexandrovEtAl/signatures.txt}

\code{AlexCosmic}: \url{https://cancer.sanger.ac.uk/cancergenome/assets/signatures_probabilities.txt}
}
\usage{
data(sigs)
}
\description{
The numerical data of the mutational signatures published initially by 
Alexandrov et al. (Nature 2013) and Alexandrov et al., (Bioaxiv 2018) is 
stored in data frames with endings \code{_sig_df}, the associated 
meta-information is stored in data frames with endings \code{_sigInd_df}. 
There are several instances of \code{_sig_df} and \code{_sigInd_df}, 
corresponding to results and data obtained at different times and with 
different raw data. There always is a one-to-one correspondence between
a \code{_sig_df} and a \code{_sigInd_df}. The data frames of type 
\code{_sig_df} have as many rows as there are features, i.e. 96 if 
analyzing mutational signatures of SNVs in a triplet context, and as
many columns as there are signatures.
Data frames of type \code{_sigInd_df} have as many rows as there are 
signatures in the corresponding \code{_sig_df} and several columns: 
\itemize{
 \item \code{sig}: signature name
 \item \code{index}: corresponding to the row index of the signature
 \item \code{colour}: colour for visualization in stacked barplots
 \item \code{process}: asserted biological process
 \item \code{cat.coarse}: categorization of the signatures according
  to the asserted biological processes at low level of detail
 \item \code{cat.medium}: categorization of the signatures according
  to the asserted biological processes at intermediate level of detail
 \item \code{cat.high}: categorization of the signatures according
  to the asserted biological processes at high level of detail
 \item \code{cat.putative}: categorization of the signatures according
  to the asserted biological processes based on clustering and inference
 }
 Please note, that categorization columns are only present for the data 
 frames corrosponding to the data from Alexandorv et al. (Nature 2013).

\code{AlexInitialArtif_sig_df}: Data frame of the signatures published 
initially by Alexandrov et al. 
(Nature 2013). There are 27 signatures which constitute the columns, 22 of 
which were validated by an orhtogonal sequencing technology. These 22 are in
the first 22 columns of the data frame. The column names are \emph{A} pasted
to the number of the signature, e.g. \emph{A5}. The nonvalidated signatures
have an additional letter in their naming convention: either 
\emph{AR1} - \emph{AR3} or \emph{AU1} - \emph{AU2}. The rownames are the 
features, i.e. an encoding of the nucleotide exchanges in their 
trinucleotide context, e.g. \emph{C>A ACA}. In total there are 96 different 
features and therefore 96 rows when dealing with a trinucleotide context.

\code{AlexInitialArtif_sigInd_df}: Meta-information for 
\code{AlexInitialArtif_sig_df}

\code{AlexInitialValid_sig_df}: Data frame of only the validated signatures 
published initially by Alexandrov et al. (Nature 2013), corresponding to the
first 22 columns of \code{AlexInitialArtif_sig_df}

\code{AlexInitialValid_sigInd_df}: Meta-information for 
\code{AlexInitialValid_sig_df}

\code{AlexCosmicValid_sig_df}: Data frame of the updated signatures list 
maintained by Ludmil Alexandrov at
\url{https://cancer.sanger.ac.uk/cosmic/signatures}. The column names are 
\emph{AC} pasted to the number of the signature, e.g. \emph{AC5}. The naming
convention for the rows is as described for 
\code{\link{AlexInitialArtif_sig_df}}.

\code{AlexCosmicValid_sigInd_df}: Meta-information for 
\code{AlexCosmicValid_sig_df}

\code{AlexCosmicArtif_sig_df}: Data frame of the updated signatures list 
maintained by Ludmil Alexandrov at
\url{https://cancer.sanger.ac.uk/cosmic/signatures} and complemented by the 
artifact signatures from the initial publication, i.e. the last 5 columns of
\code{\link{AlexInitialArtif_sig_df}}. The column names are \emph{AC} pasted
to the number of the signature, e.g. \emph{AC5}. The naming convention for 
the rows is as described for \code{\link{AlexInitialArtif_sig_df}}.

\code{AlexCosmicArtif_sigInd_df}: Meta-information for 
\code{AlexCosmicArtif_sig_df}
}
\references{
Alexandrov et al. (Nature 2013)
}
\author{
Daniel Huebschmann \email{huebschmann.daniel@googlemail.com}
}
