% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{shapiro_if_possible}
\alias{shapiro_if_possible}
\title{Wrapper for Shapiro test but allow for all identical values}
\usage{
shapiro_if_possible(in_vector)
}
\arguments{
\item{in_vector}{Numerical vector the Shapiro-Wilk test is computed on}
}
\value{
p-value of the Shapiro-Wilk test, zero if all entries in the input
 vector \code{in_vector} are identical.
}
\description{
Wrapper for Shapiro test but allow for all identical values
}
\examples{
 shapiro_if_possible(runif(100,min=2,max=4))
 shapiro_if_possible(rnorm(100,mean=5,sd=3))
 shapiro_if_possible(rep(4.3,100))
 shapiro_if_possible(c("Hello","World"))

}
\seealso{
\code{\link[stats]{shapiro.test}}
}
