% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_functions.R
\name{read_entry}
\alias{read_entry}
\alias{read_list}
\title{Read a single vcf-like file into a single data frame}
\usage{
read_entry(
  current_ind,
  in_list,
  header = TRUE,
  in_header = NULL,
  variant_type = "SNV",
  delete.char = NULL,
  ...
)

read_list(in_list, in_parallel = FALSE, header = TRUE, in_header = NULL, ...)
}
\arguments{
\item{current_ind}{Index of the file to read from the list provided below.}

\item{in_list}{List of paths to vcf-like file to be read. The list may be
named.}

\item{header}{Boolean whether a header information should be read (as in
\code{\link[utils]{read.table}})}

\item{in_header}{Vector of column names to be substituted if non-NULL.}

\item{variant_type}{Default is "SNV" and provides additional plausibility and
checks, omitted if other string}

\item{delete.char}{Character to be deleted, e.g. in order to discriminate
between comment lines and header lines, if non-NULL}

\item{...}{Parameters passed on to \code{\link[utils]{read.table}}}

\item{in_parallel}{If multicore functionality is provided on a compute
cluster, this option may be set to TRUE in order to enhance speed.}
}
\value{
A vcf-like data frame

A list with entries: \itemize{ \item \code{vcf_like_df_list}: List of
  the read data frames \item \code{readVcf_time}: Object of class
  \code{proc_time}, which stores the time needed for reading in the data }
}
\description{
Note: this function uses \code{\link[utils]{read.csv}} to read vcf-like files
into data frames for single samples. As it uses
\code{\link[utils]{read.csv}}, the default value for \code{comment.char} is
"" and not "#" as it would have been for \code{\link[utils]{read.table}}.
}
\examples{
 NULL

 NULL

}
