% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indel_functions.R
\name{attribute_sequence_contex_indel}
\alias{attribute_sequence_contex_indel}
\title{Attribution of sequence context and size for an INDEL}
\usage{
attribute_sequence_contex_indel(
  in_dat,
  in_REF.field = "REF",
  in_ALT.field = "ALT",
  in_verbose = FALSE,
  in_offsetL = 10,
  in_offsetR = 50
)
}
\arguments{
\item{in_dat}{VRanges object or data frame which carries one column for the
reference base and one column for the variant base}

\item{in_REF.field}{String indicating which column of \code{in_dat} carries
the reference base if dealing with data frames}

\item{in_ALT.field}{String indicating which column of \code{in_dat} carries
the variant base if dealing with data frames}

\item{in_verbose}{Verbose if \code{in_verbose=1}}

\item{in_offsetL}{Number of nucleotides which should be annotated downstream
of the variant. Per default 10 bps are annotated}

\item{in_offsetR}{Number of nucleotides which should be annotated upstream of
the catiant. Per default 50 bps are annotated}
}
\value{
VRanges object or data frame with the same number rows and additional
columns containing the type of INDEL (Ins = insertion and Del = deletion),
the annotated sequence context of the defined length, the absolute number of
exchanged nucleotides and the nucleotide exchange between \code{in_REF.field}
and \code{in_ALT.field}.
}
\description{
The function is a wrapper and uses \code{\link[YAPSA]{getSequenceContext}}
to annotate the sequence context.
}
\examples{
data(GenomeOfNl_raw)
GenomeOfNl_context <- attribute_sequence_contex_indel(
                                   in_dat = head(GenomeOfNl_raw),
                                   in_REF.field = "REF",
                                   in_ALT.field = "ALT",
                                   in_verbose = FALSE,
                                   in_offsetL= 10, in_offsetR=50)
GenomeOfNl_context

}
