% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{add_annotation}
\alias{add_annotation}
\title{Add information to an annotation data structure}
\usage{
add_annotation(
  in_annotation_col,
  in_annotation_df,
  in_attribution_vector,
  in_colour_vector,
  in_name
)
}
\arguments{
\item{in_annotation_col}{List, every element of which refers to one layer 
of annotation List elements are structures corresponding to named colour
vectors}

\item{in_annotation_df}{Data frame, every column of which corresponds to a
layer of annotation. It has as many rows as there are samples, every 
entry in a row corresponding to the attribute the samples has for the
corresponding layer of annotation.The factor levels of a column of
\code{in_annotation_df} correspond to the names of the corresponding
element in \code{in_annotation_col}}

\item{in_attribution_vector}{A vector which is going to be cbinded to
\code{in_annotatiin_df}, carrying the annotation information of the new
layer to be added}

\item{in_colour_vector}{Named vector of colours to be attributed to the new
annotation}

\item{in_name}{Name of the new layer of annotation}
}
\value{
A list with entries \itemize{ \item \code{annotation_col}: A list 
  as in \code{in_annotation_col} but with one additional layer of annotation
  \item \code{annotation_df}: A data frame as in \code{in_annotation_df}
  but with one additional layer of annotation}
}
\description{
Function to iteratively add information to an annotation data structure as
needed for \code{\link[ComplexHeatmap]{HeatmapAnnotation}} and especially 
for \code{\link{annotation_exposures_barplot}}
}
\examples{
 NULL

}
