% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_expressionData_Functions.R
\name{summarizeMolecularProfiles}
\alias{summarizeMolecularProfiles}
\title{Summarize molecular profiles}
\usage{
summarizeMolecularProfiles(
  object,
  drug,
  mDataType,
  tissue = NULL,
  sensitivity.measure = NULL,
  unique.model = TRUE,
  batch = NULL
)
}
\arguments{
\item{object}{The \code{XevaSet}.}

\item{drug}{Name of the drug.}

\item{mDataType}{\code{character}, where one of the molecular data types is needed.}

\item{tissue}{Default \code{NULL} will return all tissue types.}

\item{sensitivity.measure}{Default \code{NULL} will return all sensitivity measures.}

\item{unique.model}{Default \code{TRUE} will return only one sequncing ID, in the case where one model ID maps to several sequencing IDs.}

\item{batch}{Name of the batch. Default \code{NULL}.}
}
\value{
An \code{ExpressionSet} where sample names are \code{model.id} and sensitivity measures will be presented in \code{pData}.
}
\description{
This function serves to get molecular profiles from a \code{XevaSet} object.
}
\details{
\itemize{
\item {If a sequencing sample belongs to multiple models, \code{summarizeMolecularProfiles}
will create a separate column for each model.}
\item {All models without molecular data will be removed from the output \code{ExpressionSet}.}
}
}
\examples{
data(brca)
pacRNA <- summarizeMolecularProfiles(brca, drug="paclitaxel", mDataType="RNASeq",
                                     tissue= "BRCA", sensitivity.measure="mRECIST")
print(pacRNA)
}
