% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_matrices.R
\name{response}
\alias{response}
\title{compute PDX response}
\usage{
response(
  object,
  model.id = NULL,
  batch = NULL,
  res.measure = c("mRECIST", "slope", "AUC", "angle", "abc", "TGI", "lmm"),
  treatment.only = FALSE,
  max.time = NULL,
  impute.value = TRUE,
  min.time = 10,
  concurrent.time = TRUE,
  vol.normal = FALSE,
  log.volume = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{Xeva object.}

\item{model.id}{\code{model.id} for which the durg response is to be computed.}

\item{batch}{\code{batch.id} or experiment design for which the drug response is to be computed.}

\item{res.measure}{Drug response measure. See \code{Details} below}

\item{treatment.only}{Default \code{FALSE}. If \code{TRUE}, give data for non-zero dose periods only (if dose data are available).}

\item{max.time}{Maximum time for data.}

\item{impute.value}{Default \code{FALSE}. If \code{TRUE}, impute the missing values.}

\item{min.time}{Default \strong{10} days. Used for \emph{mRECIST} computation.}

\item{concurrent.time}{Default \code{FALSE}. If \code{TRUE}, cut the batch data such that control and treatment will end at same time point.}

\item{vol.normal}{If TRUE it will normalize the volume. Default \code{FALSE}.}

\item{log.volume}{If TRUE log of the volume will be used for response calculation. Default \code{FALSE}}

\item{verbose}{Default \code{TRUE} will print information.}
}
\value{
Returns model or batch drug response object.
}
\description{
\code{response} Computes the drug response of an individual PDX model or batch.
}
\details{
At present the following response measures are implemented
\itemize{
\item mRECIST Computes mRECIST for individual PDX models
\item slope Computes slope of the fitted individual PDX curves
\item AUC  Computes area under a PDX curve for individual PDX models
\item angle Computes angle between treatment and control PDX curves
\item abc Computes area between the treatment and control PDX curves
\item TGI Computes tumor growth inhibition using treatment and control PDX curves
\item lmm Computes linear mixed model (lmm) statistics for a PDX batch
}
}
\examples{
data(brca)
response(brca, model.id="X.1004.BG98", res.measure="mRECIST")

response(brca, batch="X-6047.paclitaxel", res.measure="angle")

ed <- list(batch.name="myBatch", treatment=c("X.6047.LJ16","X.6047.LJ16.trab"),
             control=c("X.6047.uned"))
response(brca, batch=ed, res.measure="angle")

}
