% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mRECIST.R
\name{plotmRECIST}
\alias{plotmRECIST}
\title{To plot mRECIST values}
\usage{
plotmRECIST(
  mat,
  control.name = NA,
  control.col = "#238b45",
  drug.col = "black",
  colPalette = NULL,
  name = "Drug & Models",
  sort = TRUE,
  row_fontsize = 12,
  col_fontsize = 12,
  draw_plot = TRUE
)
}
\arguments{
\item{mat}{The mRECIST matrix where rows are drugs and columns are patients.}

\item{control.name}{Name of the control.}

\item{control.col}{Color of the control.}

\item{drug.col}{Color of the drug names.}

\item{colPalette}{Color palette for mRECIST values.}

\item{name}{Title of the plot.}

\item{sort}{If matrix should be sorted before plotting.}

\item{row_fontsize}{Size of the row name font.}

\item{col_fontsize}{Size of the column name font.}

\item{draw_plot}{Default \code{TRUE} will plot the figure. If \code{FALSE}, return an object.}
}
\value{
mRECIST plot.
}
\description{
\code{plotmRECIST} plots the mRECIST matrix obtained from \code{summarizeResponse}.
}
\examples{
data(brca)
brca.mr <- summarizeResponse(brca, response.measure = "mRECIST", group.by="patient.id")
plotmRECIST(as.matrix(brca.mr), control.name = "untreated")
}
