% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vplot-chroms.R
\name{plotProfile}
\alias{plotProfile}
\title{A function to generate a Vplot along chromosome coordinates}
\usage{
plotProfile(
  fragments,
  window = loc,
  loci = NULL,
  annots = NULL,
  min = 50,
  max = 200,
  alpha = 0.5,
  size = 1,
  with_densities = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{fragments}{GRanges}

\item{window}{character, chromosome location}

\item{loci}{GRanges, optional genomic locus. Fragments overlapping 
this locus will be in red.}

\item{annots}{GRanges, optional gene annotations}

\item{min}{integer, minimum fragment size}

\item{max}{integer, maximum fragment size}

\item{alpha}{float, transparency value}

\item{size}{float, dot size}

\item{with_densities}{Boolean, should the densities be plotted?}

\item{verbose}{Boolean}
}
\value{
A ggplot
}
\description{
The paired-end fragments overlapping a locus of interest 
(e.g., binding sites, provided in the `loci` argument) are shown in red 
while the remaining fragments mapping to the genomic window are 
displayed in black. 
Marginal curves are also plotted on the side of the distribution plot. 
They highlight the smoothed distribution of the position of paired-end 
fragment midpoints (top) or of the paired-end fragment length (right)
}
\examples{
data(bam_test)
data(ce11_proms)
V <- plotProfile(
    bam_test,
    'chrI:10000-12000',
    loci = ce11_proms,
    min = 80, 
    max = 200
)
}
