% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstat.R
\name{plotVariogram}
\alias{plotVariogram}
\title{Plot variogram}
\usage{
plotVariogram(
  sfe,
  features,
  sample_id = "all",
  color_by = NULL,
  group = c("none", "sample_id", "features", "angles"),
  use_lty = TRUE,
  show_np = TRUE,
  ncol = NULL,
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL,
  divergent = FALSE,
  diverge_center = NULL,
  swap_rownames = NULL,
  name = "variogram"
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{features}{Features to plot, must be in rownames of the gene count
matrix, colnames of colData or a colGeometry, colnames of cell embeddings
in \code{reducedDim}, or numeric indices of dimension reduction components.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{color_by}{Name of a column in \code{rowData(sfe)} or in the
\code{featureData} of \code{colData} (see \code{\link{colFeatureData}}),
\code{colGeometry}, or \code{annotGeometry} by which to color the
correlogram of each feature. Alternatively, a vector of the same length as
\code{features}, or a data frame from \code{\link{clusterCorrelograms}}.}

\item{group}{Which of samples, features, and angles to show in the same facet
for comparison when there are multiple. Default to "none", meaning each
facet will contain one variogram. When grouping multiple variograms in the
same facet, the text with model, nugget, sill, and range of the variograms
will not be shown.}

\item{use_lty}{Logical, whether to use linetype or point shape to distinguish
between the different features or samples in the same facet. If
\code{FALSE}, then the different features or samples are not distinguished
and the patterns are shown only.}

\item{show_np}{Logical, whether to show number of pairs of cells at each
distance bin.}

\item{ncol}{Number of columns if facetting.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}

\item{divergent}{Logical, whether a divergent palette should be used.}

\item{diverge_center}{If \code{divergent = TRUE}, the center from which the
palette should diverge. If \code{NULL}, then not centering.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{name}{Name under which the correlogram results are stored, which is by
default "sp.correlogram".}
}
\value{
A \code{ggplot} object. The empirical variogram at each distance bin
  is plotted as points, and the fitted variogram model is plotted as a line
  for each feature. The number next to each point is the number of pairs of
  cells in that distance bin.
}
\description{
This function plots the variogram of a feature and its fitted variogram
models, showing the nugget, range, and sill of the model. Unlike the plotting
functions in package \code{automap} that uses \code{lattice}, this function
uses \code{ggplot2} to make prettier and more customizable plots.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData()
sfe <- colDataUnivariate(sfe, "variogram", features = "nCounts", model = "Sph")
plotVariogram(sfe, "nCounts")
# Anisotropy, will get a message
sfe <- colDataUnivariate(sfe, "variogram", features = "nCounts",
model = "Sph", alpha = c(30, 90, 150), name = "variogram_anis")
# Facet by angles by default
plotVariogram(sfe, "nCounts", name = "variogram_anis")
# Plot angles with different colors
plotVariogram(sfe, "nCounts", group = "angles", name = "variogram_anis")
}
\seealso{
plotVariogramMap
}
\concept{Plot spatial analysis results}
