% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstat.R
\name{plotCrossVariogram}
\alias{plotCrossVariogram}
\title{Plot cross variogram}
\usage{
plotCrossVariogram(res, show_np = TRUE)
}
\arguments{
\item{res}{Cross variogram results for one sample, from
\code{\link{calculateBivariate}}. Global bivariate results are not stored
in the SFE object.}

\item{show_np}{Logical, whether to show number of pairs of cells at each
distance bin.}
}
\value{
A ggplot object. Unfortunately I haven't figured out a way to collect
all the facet labels to the top of the entire plot.
}
\description{
Equivalent to \code{gstat::plot.gstatVariogram}, but using ggplot2 to be more
customizable.
}
\examples{
library(SFEData)
library(scater)
sfe <- McKellarMuscleData()
sfe <- sfe[,sfe$in_tissue]
sfe <- logNormCounts(sfe)

res <- calculateBivariate(sfe, type = "cross_variogram",
feature1 = c("Myh1", "Myh2", "Csrp3"), swap_rownames = "symbol")
plotCrossVariogram(res)
}
\seealso{
plotCrossVariogramMap
}
\concept{Plot spatial analysis results}
