% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-univar-downstream.R
\name{plotCorrelogram}
\alias{plotCorrelogram}
\title{Plot correlogram}
\usage{
plotCorrelogram(
  sfe,
  features,
  sample_id = "all",
  method = "I",
  color_by = NULL,
  facet_by = c("sample_id", "features"),
  ncol = NULL,
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL,
  plot_signif = TRUE,
  p_adj_method = "BH",
  divergent = FALSE,
  diverge_center = NULL,
  swap_rownames = NULL,
  name = "sp.correlogram"
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{features}{Features to plot, must be in rownames of the gene count
matrix, colnames of colData or a colGeometry, colnames of cell embeddings
in \code{reducedDim}, or numeric indices of dimension reduction components.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{method}{"corr" for correlation, "I" for Moran's I, "C" for Geary's C}

\item{color_by}{Name of a column in \code{rowData(sfe)} or in the
\code{featureData} of \code{colData} (see \code{\link{colFeatureData}}),
\code{colGeometry}, or \code{annotGeometry} by which to color the
correlogram of each feature. Alternatively, a vector of the same length as
\code{features}, or a data frame from \code{\link{clusterCorrelograms}}.}

\item{facet_by}{Whether to facet by sample_id (default) or features. If
facetting by sample_id, then different features will be plotted in the same
facet for comparison. If facetting by features, then different samples will
be compared for each feature. Ignored if only one sample is specified.}

\item{ncol}{Number of columns if facetting.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}

\item{plot_signif}{Logical, whether to plot significance symbols: p < 0.001:
***, p < 0.01: **, p < 0.05 *, p < 0.1: ., otherwise no symbol. The
p-values are two sided, based on the assumption that the estimated Moran's
I is normally distributed with mean from a randomized version of the data.
The mean and variance come from \code{\link{moran.test}} for Moran's I and
\code{\link{geary.test}} for Geary's C. Take the results with a grain of
salt if the data is not normally distributed.}

\item{p_adj_method}{Multiple testing correction method as in
\code{\link{p.adjust}}, to correct for multiple testing (number of lags
times number of features) in the Moran's I estimates if \code{plot_signif =
TRUE}.}

\item{divergent}{Logical, whether a divergent palette should be used.}

\item{diverge_center}{If \code{divergent = TRUE}, the center from which the
palette should diverge. If \code{NULL}, then not centering.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{name}{Name under which the correlogram results are stored, which is by
default "sp.correlogram".}
}
\value{
A ggplot object.
}
\description{
Use \code{ggplot2} to plot correlograms computed by
\code{\link{runUnivariate}}, pulling results from \code{rowData}.
Correlograms of multiple genes with error bars can be plotted, and they can
be colored by any numeric or categorical column in \code{rowData} or a vector
with the same length as \code{nrow} of the SFE object. The coloring is useful
when the correlograms are clustered to show types of length scales or
patterns of decay of spatial autocorrelation. For \code{method = "I"}, the
error bars are twice the standard deviation of the estimated Moran's I value.
}
\examples{
library(SpatialFeatureExperiment)
library(SFEData)
library(bluster)
library(scater)
sfe <- McKellarMuscleData("small")
sfe <- logNormCounts(sfe)
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
inds <- c(1, 3, 4, 5)
features <- rownames(sfe)[inds]
sfe <- runUnivariate(sfe,
    type = "sp.correlogram", features = features,
    exprs_values = "counts", order = 5
)
clust <- clusterCorrelograms(sfe,
    features = features,
    BLUSPARAM = KmeansParam(2)
)
# Color by features
plotCorrelogram(sfe, features)
# Color by something else
plotCorrelogram(sfe, features, color_by = clust$cluster)
# Facet by features
plotCorrelogram(sfe, features, facet_by = "features")
}
\concept{Plot spatial analysis results}
