% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotColGraph}
\alias{plotColGraph}
\alias{plotAnnotGraph}
\title{Plot spatial graphs}
\usage{
plotColGraph(
  sfe,
  colGraphName = 1L,
  colGeometryName = 1L,
  sample_id = "all",
  weights = FALSE,
  segment_size = 0.5,
  geometry_size = 0.5,
  ncol = NULL,
  bbox = NULL
)

plotAnnotGraph(
  sfe,
  annotGraphName = 1L,
  annotGeometryName = 1L,
  sample_id = "all",
  weights = FALSE,
  segment_size = 0.5,
  geometry_size = 0.5,
  ncol = NULL,
  bbox = NULL
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{colGraphName}{Name of graph associated with columns of the gene count
matrix to be plotted.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{weights}{Whether to plot weights. If \code{TRUE}, then transparency
(alpha) of the segments will represent edge weights.}

\item{segment_size}{Thickness of the segments that represent graph edges.}

\item{geometry_size}{Point size (for POINT geometries) or line thickness (for
LINESTRING and POLYGON) to plot the geometry in the background.}

\item{ncol}{Number of columns if plotting multiple features. Defaults to
\code{NULL}, which means using the same logic as \code{facet_wrap}, which
is used by \code{patchwork}'s \code{\link{wrap_plots}} by default.}

\item{bbox}{A bounding box to specify a smaller region to plot, useful when
the dataset is large. Can be a named numeric vector with names "xmin",
"xmax", "ymin", and "ymax", in any order. If plotting multiple samples, it
should be a matrix with sample IDs as column names and "xmin", "ymin",
"xmax", and "ymax" as row names. If multiple samples are plotted but
\code{bbox} is a vector rather than a matrix, then the same bounding box
will be used for all samples. You may see points at the edge of the
geometries if the intersection between the bounding box and a geometry
happens to be a point there. If \code{NULL}, then the entire tissue is
plotted.}

\item{annotGraphName}{Name of the annotation graph to plot.}

\item{annotGeometryName}{Name of the \code{annotGeometry}, which is
associated with the graph specified with \code{annotGraphName}, for spatial
coordinates of the graph nodes and for context.}
}
\value{
A ggplot2 object.
}
\description{
A ggplot version of \code{spdep::plot.nb}, reducing boilerplate for SFE
objects.
}
\examples{
library(SpatialFeatureExperiment)
library(SFEData)
library(sf)
sfe <- McKellarMuscleData("small")
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
plotColGraph(sfe, colGraphName = "visium", colGeometryName = "spotPoly")
# Make the myofiber segmentations a valid POLYGON geometry
ag <- annotGeometry(sfe, "myofiber_simplified")
ag <- st_buffer(ag, 0)
ag <- ag[!st_is_empty(ag), ]
annotGeometry(sfe, "myofiber_simplified") <- ag
annotGraph(sfe, "myofibers") <-
    findSpatialNeighbors(sfe,
        type = "myofiber_simplified", MARGIN = 3,
        method = "tri2nb", dist_type = "idw"
    )
plotAnnotGraph(sfe,
    annotGraphName = "myofibers",
    annotGeometryName = "myofiber_simplified",
    weights = TRUE
)
}
\concept{Spatial plotting}
