% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFEMethod-multivariate.R
\name{multispati_rsp}
\alias{multispati_rsp}
\title{A faster implementation of MULTISPATI PCA}
\usage{
multispati_rsp(x, listw, nfposi = 30L, nfnega = 30L, scale = TRUE)
}
\arguments{
\item{x}{A matrix whose columns are features and rows are cells.}

\item{listw}{A \code{listw} object, a spatial neighborhood graph for the
cells in \code{x}. The length must be equal to the number of row of
\code{x}.}

\item{nfposi}{Number of positive eigenvalues and their eigenvectors to
compute.}

\item{nfnega}{Number of nega eigenvalues and their eigenvectors to compute.
These indicate negative spatial autocorrelation.}

\item{scale}{Logical, whether to scale the data.}
}
\value{
A matrix for the cell embeddings in each spatial PC, with attribute
  \code{loading} for the eigenvectors or gene loadings, and attribute
  \code{eig} for the eigenvalues.
}
\description{
This implementation uses the \code{RSpectra} package to efficiently compute a
small subset of eigenvalues and eigenvectors, as a small subset is typically
used. Hence it's much faster and memory efficient than the original
implementation in \code{adespatial}. However, this implementation here does
not support row and column weighting other than the standard ones for PCA.,
so the \code{adespatial} implementation is more general.
}
\note{
Eigen decomposition will fail if any feature has variance zero leading to NaN
in the scaled matrix.
}
\examples{
library(SFEData)
library(scater)
sfe <- McKellarMuscleData("small")
sfe <- sfe[,sfe$in_tissue]
sfe <- logNormCounts(sfe)
inds <- order(rowSums(logcounts(sfe)), decreasing = TRUE)[1:50]
mat <- logcounts(sfe)[inds,]
g <- findVisiumGraph(sfe)
out <- multispati_rsp(t(mat), listw = g, nfposi = 10, nfnega = 10)
}
\references{
Dray, S., Said, S. and Debias, F. (2008) Spatial ordination of vegetation data using a generalization of Wartenberg's multivariate spatial correlation. Journal of vegetation science, 19, 45-56.
}
\concept{Internal spatial statistics functions}
