% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial-misc.R
\name{moranBounds}
\alias{moranBounds}
\title{Compute the bounds of Moran's I given spatial neighborhood graph}
\usage{
moranBounds(listw)
}
\arguments{
\item{listw}{A listw object for the spatial neighborhood graph.}
}
\value{
A numeric vector of minimum and maximum Moran's I given the spatial
  neighborhood graph.
}
\description{
Values Moran's I can take depends on the spatial neighborhood graph. The
bounds of Moran's I given the graph, C, are given by the minimum and maximum
eigenvalues of the double centered -- i.e. subtracting column means and row
means -- adjacency matrix \eqn{(I - \mathbb{11}^T/n)C(I - \mathbb{11}^T/n)}{(I
- 11^T/n)C(I - 11^T/n)}, where \eqn{\mathbb 1}{1} is a vector of all 1's.
This implementation follows the implementation in \code{adespatial} and uses
the \code{RSpectra} package to more quickly find only the minimum and maximum
eigenvalues without performing unnecessary work to find the full spectrum as
done in base R's \code{\link{eigen}}.
}
\note{
After double centering, the adjacency matrix is no longer sparse, so this
function can take up a lot of memory for larger datasets.
}
\examples{
# example code
library(SFEData)
sfe <- McKellarMuscleData("small")
g <- findVisiumGraph(sfe)
moranBounds(g)
}
\references{
de Jong, P., Sprenger, C., & van Veen, F. (1984). On extreme values of Moran's I and Geary's C. Geographical Analysis, 16(1), 17-24.
}
\concept{Spatial statistics}
