% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listSFEMethods.R
\name{listSFEMethods}
\alias{listSFEMethods}
\title{List all spatial methods in Voyager package}
\usage{
listSFEMethods(variate = c("uni", "bi", "multi"), scope = c("global", "local"))
}
\arguments{
\item{variate}{Uni-, bi-, or multi-variate.}

\item{scope}{whether it's local or global.}
}
\value{
A data frame with a column for the name and another for a brief
  description.
}
\description{
This package ships with many spatial statistics methods as
\code{\link{SFEMethod}} objects. The user can adapt the uniform user
interface of this package to other spatial methods by creating new
\code{SFEMethod} objects. This function lists the names of all methods within
\code{Voyager}, to use for the \code{type} argument in
\code{\link{calculateUnivariate}}, \code{\link{calculateBivariate}}, and
\code{\link{calculateMultivariate}}.
}
\examples{
listSFEMethods("uni", "local")
}
\concept{Spatial statistics}
