% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runfgsea.R
\name{runfgsea}
\alias{runfgsea}
\alias{runfgsea,ANY,gene2GO,character-method}
\title{perform multilevel preranked gene set enrichment analysis.}
\usage{
runfgsea(
  geneSel,
  gene2GO,
  ont,
  method = c("fgseaSimple", "fgseaMultilevel"),
  params = list(nperm = 10000, sampleSize = 101, minSize = 1, maxSize = Inf, eps = 0,
    scoreType = c("std", "pos", "neg"), nproc = 0, gseaParam = 1, BPPARAM = NULL, absEps
    = NULL)
)

\S4method{runfgsea}{ANY,gene2GO,character}(
  geneSel,
  gene2GO,
  ont,
  method = c("fgseaSimple", "fgseaMultilevel"),
  params = list(nperm = 10000, sampleSize = 101, minSize = 1, maxSize = Inf, eps = 0,
    scoreType = c("std", "pos", "neg"), nproc = 0, gseaParam = 1, BPPARAM = NULL, absEps
    = NULL)
)
}
\arguments{
\item{geneSel}{a 2 columns \code{data.table} with \bold{preranked} gene identifiants (in first column) based on the statistical values (second column).}

\item{gene2GO}{a \code{\link{gene2GO-class}} object created by \code{\link{annotate}} method.}

\item{ont}{the ontology used is "MF" (Molecuar Function), "BP" (Biological Process), or "CC" (Cellular Component).}

\item{method}{fgsea method to use with \code{\link[fgsea]{fgseaSimple}} or \code{\link[fgsea]{fgseaMultilevel}}.}

\item{params}{a \code{list} with \code{\link[fgsea]{fgseaSimple}} or \code{\link[fgsea]{fgseaMultilevel}} parameters.}
}
\value{
a \code{\link{fgsea-class}} object.
}
\description{
This method perform fast gene set enrichment analysis (GSEA) using \pkg{fgsea} package.
}
\details{
This method is a convenient wrapper using a given ontology category (\code{ont} argument)
in order to perform gene set enrichment analysis using \code{\link[fgsea]{fgseaSimple}} or
\code{\link[fgsea]{fgseaMultilevel}} algorithm from  \pkg{fgsea} package.

The complete GO annotation is required (\code{gene2GO} argument), and also a 2 columns \code{data.table} with \bold{preranked}
gene identifiants (in first column) based on statistical values (second column).

Defaults fgseaSimple parameters were used for perform test with \code{nperm} set to 10,000.\cr
Defaults fgseaMultilevel parameters were used for perform test 
except the \code{eps} arg that was set to 0 for better pvalues estimation.\cr
A gene frequency (\%) of leadingEdge/size is added to output \code{data.table}.
}
\examples{
# gene list
PregnantvsLactate<-data.table::fread(
    system.file(
        "extdata/data/input",
        "pregnantvslactate.complete.txt",
        package = "ViSEAGO"
    ),
    select = c("Id","padj")
)

# rank Id based on statistical value (padj here)
PregnantvsLactate<-data.table::setorder(PregnantvsLactate,padj)

\dontrun{
# connect to Bioconductor
Bioconductor<-ViSEAGO::Bioconductor2GO()

myGENE2GO<-ViSEAGO::annotate(
   "org.Mm.eg.db",
   Bioconductor
)

# run fgseaMultilevel
pregnantvslactate<-ViSEAGO::runfgsea(
    geneSel=PregnantvsLactate,
    gene2GO=myGENE2GO,
    ont="BP",
    method="fgseaMultilevel",
    params=list(
        minSize=5,
        scoreType="pos"
    )
)
}
}
\references{
Korotkevich G, Sukhov V, Sergushichev A (2019). "Fast gene set enrichment analysis." bioRxiv. doi: 10.1101/060012, http://biorxiv.org/content/early/2016/06/20/060012.
}
\seealso{
Other GO_terms: 
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{annotate}()},
\code{\link{create_topGOdata}()},
\code{\link{gene2GO-class}},
\code{\link{merge_enrich_terms}()}
}
\concept{GO_terms}
