% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EntrezGene2GO.R
\name{EntrezGene2GO}
\alias{EntrezGene2GO}
\title{Store available organisms GO annotations at EntrezGene.}
\usage{
EntrezGene2GO()
}
\value{
a  \code{\link{genomic_ressource-class}} object required by \code{\link{annotate}}.
}
\description{
Store the available species and current GO annotations from the
\href{https://ftp.ncbi.nih.gov/gene/DATA/gene2go.gz}{gene2go.gz} nfile avalable at NCBI \href{https://ftp.ncbi.nih.gov/gene/DATA}{EntrezGene ftp}.
}
\details{
This function downloads the \href{https://ftp.ncbi.nih.gov/gene/DATA/gene2go.gz}{gene2go.gz} file from
\href{https://ftp.ncbi.nih.gov/gene/DATA}{EntrezGene ftp} which contains available organisms (taxid) with the corresponding GO annotations.
}
\examples{
\dontrun{
# Download EntrezGene available organisms GO annotations
EntrezGene<-ViSEAGO::EntrezGene2GO()
}
}
\references{
Matt Dowle and Arun Srinivasan (2017). data.table: Extension of `data.frame`. R package version 1.10.4. https://CRAN.R-project.org/package=data.table.

Eric Sayers (2013). Entrez Programming Utilities Help.

#' Henrik Bengtsson (2016). R.utils: Various Programming Utilities. R package version 2.5.0. https://CRAN.R-project.org/package=R.utils.

Maglott, D, Ostell, J, Pruitt, KD, Tatusova, T (2011). Entrez Gene: gene-centered information at NCBI. Nucleic Acids Res., 39, Database issue:D52-7.
}
\seealso{
Other genomic_ressource: 
\code{\link{Bioconductor2GO}()},
\code{\link{Custom2GO}()},
\code{\link{Ensembl2GO}()},
\code{\link{Uniprot2GO}()},
\code{\link{annotate}()},
\code{\link{available_organisms}()},
\code{\link{genomic_ressource-class}},
\code{\link{taxonomy}()}
}
\concept{genomic_ressource}
