% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{upsetPlot}
\alias{upsetPlot}
\title{Create an UpSet plot}
\usage{
upsetPlot(
  object,
  nintersects = 40,
  min_size = 1,
  sets_bar_color = NULL,
  main_bar_color = "steelblue",
  point_size = 3,
  line_size = 1,
  show_numbers = TRUE,
  sort_intersections_by = "freq",
  sort_sets_by = "size",
  sort_sets_decreasing = TRUE,
  custom_sets_order = NULL,
  sort_intersections_decreasing = TRUE,
  custom_intersections_order = NULL,
  intersection_color = "black",
  highlight_intersections = NULL,
  highlight_color = "darkorange",
  empty_point_size = 1.5,
  bar_width = 0.7,
  text_angle = 0,
  text_size = 10,
  set_label_size = 3,
  intersection_label_size = 3,
  point_outline_color = "black",
  point_stroke = 0.3,
  set_size_show_values = TRUE,
  intersection_size_show_values = TRUE,
  show_empty_intersections = FALSE,
  show_set_labels = TRUE,
  plot_margin = 0.5,
  height_ratio = 0.7,
  width_ratio = 0.3,
  bar_offset = -0.01,
  set_text_size = 10,
  intersection_title = "Intersection Size",
  set_size_title = "Set Size",
  matrix_point_shape = 21,
  number_color_threshold = 0.75,
  number_colors = c(on_bar = "black", off_bar = "black"),
  theme_params = list(background_color = "white", grid_color = "grey92", axis_text_color
    = "black", use_grid = TRUE, border_color = NA),
  title = NULL,
  interactive = FALSE,
  return_data = FALSE,
  ...
)
}
\arguments{
\item{object}{A Venn object}

\item{nintersects}{Maximum number of intersections to show}

\item{min_size}{Minimum intersection size to include (default: 1)}

\item{sets_bar_color}{Colors for the set size bars}

\item{main_bar_color}{Color for the intersection size bars}

\item{point_size}{Size of points in the matrix}

\item{line_size}{Width of lines in the matrix}

\item{show_numbers}{Logical: show counts on bars?}

\item{sort_intersections_by}{How to sort intersections}

\item{sort_sets_by}{How to sort sets}

\item{sort_sets_decreasing}{Whether to sort sets in decreasing order}

\item{custom_sets_order}{Custom order for sets if sort_sets_by="custom"}

\item{sort_intersections_decreasing}{Whether to sort intersections in decreasing order}

\item{custom_intersections_order}{Custom order for intersections}

\item{intersection_color}{Color for intersection dots and lines}

\item{highlight_intersections}{Vector of intersection IDs to highlight}

\item{highlight_color}{Color for highlighted intersections}

\item{empty_point_size}{Size of empty points in the matrix}

\item{bar_width}{Width of bars}

\item{text_angle}{Angle for text labels}

\item{text_size}{Size of text in the plot}

\item{set_label_size}{Size of set size labels}

\item{intersection_label_size}{Size of intersection size labels}

\item{point_outline_color}{Color for the outline of points}

\item{point_stroke}{Width of point outline}

\item{set_size_show_values}{Whether to show set size values}

\item{intersection_size_show_values}{Whether to show intersection size values}

\item{show_empty_intersections}{Whether to show empty intersections}

\item{show_set_labels}{Whether to show set labels}

\item{plot_margin}{Margin around the plots in cm}

\item{height_ratio}{Ratio of matrix to total height}

\item{width_ratio}{Ratio of set size to total width}

\item{bar_offset}{Horizontal offset for top bars}

\item{set_text_size}{Size of set labels}

\item{intersection_title}{Title for the intersection size plot}

\item{set_size_title}{Title for the set size plot}

\item{matrix_point_shape}{Shape of the dots in the matrix}

\item{number_color_threshold}{Fraction of max value for label color switch}

\item{number_colors}{Colors for labels on/off bars}

\item{theme_params}{Theme parameters for customization}

\item{title}{Optional plot title}

\item{interactive}{Create interactive plot?}

\item{return_data}{Whether to return the data along with the plot}

\item{...}{Additional arguments passed to internal functions}
}
\value{
A ggplot object or a combined grid layout
}
\description{
Creates an UpSet plot to visualize set intersections
}
\examples{
# Basic example
sets <- list(
  "Set A" = c(1:100),
  "Set B" = c(30:120),
  "Set C" = c(20:50, 90:110),
  "Set D" = c(10:40, 80:120)
)
ven <- venndetail(sets)
upsetPlot(ven, bar_offset = -0.02)

# With highlighting
upsetPlot(ven,
          highlight_intersections = c(1, 2),
          highlight_color = "darkorange",
          bar_offset = -0.02)

}
\author{
Kai Guo
}
