% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-extraction.R
\name{rowjoin,data.frame,data.frame-method}
\alias{rowjoin,data.frame,data.frame-method}
\title{Join data.frames by row names or specified columns}
\usage{
\S4method{rowjoin}{data.frame,data.frame}(x, y, fun = "full_join")
}
\arguments{
\item{x}{First data.frame}

\item{y}{Second data.frame}

\item{fun}{Join function to use: "full_join", "left_join", "right_join", etc.}

\item{by}{Optional vector of column names to join by}
}
\value{
A joined data.frame
}
\description{
Joins two data.frames using various join methods
}
\examples{
library(dplyr)
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
dA <- data.frame(A = A, "FC" = rnorm(40))
dB <- data.frame(B = B, "FC" = rnorm(60))
rownames(dA) <- A
rownames(dB) <- B
# Full join by row names
result <- rowjoin(dA, dB)
# Left join by row names
result <- rowjoin(dA, dB, fun = "left_join")
}
