% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/misc.R
\name{result}
\alias{result}
\alias{result,Venn-method}
\title{Extract results from a Venn object}
\usage{
result(object, wide = FALSE)

\S4method{result}{Venn}(object, wide = FALSE)
}
\arguments{
\item{object}{A Venn object}

\item{wide}{Logical: should results be returned in wide format? Default: FALSE}
}
\value{
A data.frame containing subset information
}
\description{
Retrieves results from a Venn object in long or wide format

Result will return output in a table format including the
contents of the subsets included in the venndetail object
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
# Get results in long format
result_long <- result(res)
# Get results in wide format
result_wide <- result(res, wide = TRUE)
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
result <- result(res)
}
\author{
Kai Guo
}
