% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{merge.Venn}
\alias{merge.Venn}
\title{Merge two or more venndetail obejcts}
\usage{
\method{merge}{Venn}(x, y, ignore.case = FALSE, useupper = TRUE, plot = FALSE, ...)
}
\arguments{
\item{x}{Venn object}

\item{y}{Venn object}

\item{ignore.case}{Boolean indicating whether to ignore case of
group names (default: FALSE)}

\item{useupper}{Boolean indicating whether to use uppercases for
group names (default: TRUE)}

\item{plot}{Boolean indicating whether to plot figure or not
(default: FALSE)}

\item{...}{arguments for venndetail}
}
\value{
venn object
}
\description{
Merge will combine multiple venn diagrams to allow comparison
between multiple groups
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res1 <- venndetail(list(A = A, B = B))
res2 <- venndetail(list(A = A, C = C))
res <- merge(res1, res2)
}
