% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{make.subset}
\alias{make.subset}
\title{Get subset from list of input groups}
\usage{
make.subset(x, sep = "_")
}
\arguments{
\item{x}{A list with input groups}

\item{sep}{symbol character used when concatenating group names into subset
names}
}
\value{
A list of subsets. The names on the list are the subset names
and the list elements are the subset details.
}
\description{
Get subset from list of input groups
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
x <- list(A = A, B = B, C = C)
out <-  make.subset(x)
}
\author{
Kai Guo
}
