% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R, R/utils.R
\name{head.Venn}
\alias{head.Venn}
\title{Extract the first few rows of a Venn object}
\usage{
\method{head}{Venn}(x, n = 6L, ...)

\method{head}{Venn}(x, n = 6L, ...)
}
\arguments{
\item{x}{A Venn object}

\item{n}{Number of rows to extract}

\item{...}{Additional arguments passed to head}
}
\value{
A data frame with the first n rows
}
\description{
Extract the first n rows of the result data frame
}
\examples{
# Create a Venn object
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
res <- venndetail(list(A = A, B = B))

# Get the first few rows
head(res)
}
\author{
Kai Guo
}
