% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getFeature.R
\name{getFeature}
\alias{getFeature}
\alias{getFeature Venn}
\title{Extract feature data for specific subsets}
\usage{
getFeature(
  object,
  subset,
  rlist,
  userowname = TRUE,
  gind = NULL,
  sep = "_",
  wide = FALSE
)

\S4method{getFeature}{Venn}(
  object,
  subset,
  rlist,
  userowname = TRUE,
  gind = NULL,
  sep = "_",
  wide = FALSE
)
}
\arguments{
\item{object}{Venn object}

\item{subset}{Character vector giving the names of the user-defined
subset to extract}

\item{rlist}{List of user-supplied data frames to combine with
venndetail result}

\item{userowname}{Boolean indicating whether to use row names to join
data frames or not (default: TRUE)}

\item{gind}{Column name or index of each user-supplied data.frame to
use to join data frames(valid only when userowname=FALSE)}

\item{sep}{Character string used to separate the terms when concatenating
group names into
new separation character for new column names in the resulting data frame}

\item{wide}{Boolean indicating whether to use wide format(default:FALSE)}
}
\value{
A data.frame combining subset information with user data

data.frame with subsets information and details from the user
supplied data frame
}
\description{
Combines subset information with user-supplied data frames

GetFeature allows users to extract subsets from venn object
into a table format along with accompanying information from the data frames
provided in the rlist argument
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
dA <- data.frame(A = A, "FC" = rnorm(40))
dB <- data.frame(B = B, "FC" = rnorm(60))
dC <- data.frame(C = C, "FC" = rnorm(40))
res <- venndetail(list(A = A, B = B, C = C))
features <- getFeature(res, subset = "Shared",
                     rlist = list(dA, dB, dC),
                     userowname = FALSE,
                     gind = rep(1, 3))
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
dA <- data.frame(A = A, "FC" = rnorm(40))
dB <- data.frame(B = B, "FC" = rnorm(60))
dC <- data.frame(C = C, "FC" = rnorm(40))
res <- venndetail(list(A = A, B = B, C = C))
rhs <- getFeature(res, subset = "Shared", rlist = list(dA, dB, dC),
   userowname= FALSE, gind = rep(1, 3))
}
\author{
Kai Guo
}
