% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-extraction.R
\name{getFeature,Venn-method}
\alias{getFeature,Venn-method}
\title{Extract feature data for specific subsets}
\usage{
\S4method{getFeature}{Venn}(
  object,
  subset,
  rlist,
  userowname = TRUE,
  gind = NULL,
  sep = "_",
  wide = FALSE
)
}
\arguments{
\item{object}{A Venn object}

\item{subset}{Character vector of subset names to extract}

\item{rlist}{List of user-supplied data frames}

\item{userowname}{Logical: use row names for joining?}

\item{gind}{Column names or indices to use for joining if userowname=FALSE}

\item{sep}{Character used to separate group names in column names}

\item{wide}{Logical: return results in wide format?}
}
\value{
A data.frame combining subset information with user data
}
\description{
Combines subset information with user-supplied data frames
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
dA <- data.frame(A = A, "FC" = rnorm(40))
dB <- data.frame(B = B, "FC" = rnorm(60))
dC <- data.frame(C = C, "FC" = rnorm(40))
res <- venndetail(list(A = A, B = B, C = C))
features <- getFeature(res, subset = "Shared",
                      rlist = list(dA, dB, dC),
                      userowname = FALSE,
                      gind = rep(1, 3))
}
