% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-extraction.R
\name{dplot,Venn-method}
\alias{dplot,Venn-method}
\title{Create a bar plot of subset counts}
\usage{
\S4method{dplot}{Venn}(object, order = FALSE, textsize = 5)
}
\arguments{
\item{object}{A Venn object}

\item{order}{Logical: should bars be ordered by count?}

\item{textsize}{Numeric: size of text labels above bars}

\item{color}{Optional vector of colors for the bars}

\item{theme}{The ggplot2 theme to use}

\item{title}{Optional plot title}

\item{xlabel}{Optional x-axis label}

\item{ylabel}{Optional y-axis label}
}
\value{
A ggplot2 object
}
\description{
Creates a bar plot showing counts for each subset
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
# Simple bar plot
dplot(res)
# Ordered bars with custom title
dplot(res, order = TRUE, textsize = 3, title = "Set Intersections")
}
\author{
Kai Guo
}
