% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-AllClasses.R, R/AllClasses.R
\docType{class}
\name{Venn-class}
\alias{Venn-class}
\title{Class 'Venn'
This class includes all information from venndetail}
\description{
S4 class to store and manage set intersection data and visualizations
}
\section{Slots}{

\describe{
\item{\code{input}}{orginal input datasets}

\item{\code{raw}}{summary of the input datasets}

\item{\code{sep}}{separation character}

\item{\code{GroupNames}}{input group names}

\item{\code{result}}{shared or unique sets}

\item{\code{detail}}{shared of unique number belongs to each sets}

\item{\code{wide}}{result in wide format}

\item{\code{input}}{A list containing the original input datasets}

\item{\code{raw}}{A named vector with counts of elements in each input set}

\item{\code{sep}}{The character used to separate set names in subset labels}

\item{\code{GroupNames}}{A character vector of input group names}

\item{\code{result}}{A data.frame containing subset information (subset name and elements)}

\item{\code{detail}}{A named vector with counts of elements in each subset}

\item{\code{wide}}{A data.frame with subset information in wide format for easier analysis}

\item{\code{metadata}}{A list to store additional metadata about the analysis}
}}

\examples{
\dontrun{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
venn_obj <- venndetail(list(A = A, B = B, C = C))
# Access the detail slot
venn_obj@detail
}
}
\author{
Kai Guo
}
\keyword{classes}
