% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveVariantExperiment.R
\name{saveVariantExperiment}
\alias{saveVariantExperiment}
\title{saveVariantExperiment Save all the assays in GDS format, including
in-memory assays. Delayed assays with delayed operations on them
are realized while they are written to disk.}
\usage{
saveVariantExperiment(
  ve,
  dir = tempdir(),
  replace = FALSE,
  fileFormat = NULL,
  compress = "LZMA_RA",
  chunk_size = 1000,
  rowDataOnDisk = TRUE,
  colDataOnDisk = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{ve}{A SummarizedExperiment object, with the array data being
ordinary array structure.}

\item{dir}{The directory to save the gds format of the array data,
and the newly generated SummarizedExperiment object with array
data in GDSArray format. The default is temporary directory
within the R session.}

\item{replace}{Whether to replace the directory if it already
exists. The default is FALSE.}

\item{fileFormat}{File format for the output gds file. See details.}

\item{compress}{the compression method for writing the gds
file. The default is "LZMA_RA".}

\item{chunk_size}{The chunk size (number of columns) when reading
GDSArray-based assays from input \code{ve} into memory and then
write into a new gds file. Default is 1000. Can be modified to
smaller value if chunk data is too big (e.g., when number of
rows are large).}

\item{rowDataOnDisk}{whether to save the \code{rowData} as
DelayedArray object. The default is TRUE.}

\item{colDataOnDisk}{whether to save the \code{colData} as
DelayedArray object. The default is TRUE.}

\item{verbose}{whether to print the process messages. The default
is FALSE.}
}
\value{
An \code{VariantExperiment} object with the new
    \code{gdsfile()} \code{ve.gds} as specified in \code{dir}
    argument.
}
\description{
saveVariantExperiment Save all the assays in GDS format, including
in-memory assays. Delayed assays with delayed operations on them
are realized while they are written to disk.
}
\details{
If the input \code{SummarizedExperiment} object has
    GDSArray-based assay data, there is no need to specify the
    argument \code{fileFomat}. Otherwise, it takes values of
    \code{SEQ_ARRAY} for sequencing data or \code{SNP_ARRAY} SNP
    array data.
}
\examples{
gds <- SeqArray::seqExampleFileName("gds")
ve <- makeVariantExperimentFromGDS(gds)
gdsfile(ve)
ve1 <- subsetByOverlaps(ve, GRanges("22:1-48958933"))
ve1
gdsfile(ve1)
aa <- tempfile()
obj <- saveVariantExperiment(ve1, dir=aa, replace=TRUE)
obj
gdsfile(obj)
}
