% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeVariantExperimentFromGDS.R,
%   R/makeVariantExperimentFromSEQGDS.R, R/makeVariantExperimentFromSNPGDS.R
\name{makeVariantExperimentFromGDS}
\alias{makeVariantExperimentFromGDS}
\alias{makeVariantExperimentFromSEQGDS}
\alias{makeVariantExperimentFromSNPGDS}
\title{makeVariantExperimentFromGDS}
\usage{
makeVariantExperimentFromGDS(
  file,
  ftnode,
  smpnode,
  assayNames = NULL,
  rowDataColumns = NULL,
  colDataColumns = NULL,
  rowDataOnDisk = TRUE,
  colDataOnDisk = TRUE,
  infoColumns = NULL
)

makeVariantExperimentFromSEQGDS(
  file,
  ftnode = "variant.id",
  smpnode = "sample.id",
  assayNames = NULL,
  rowDataColumns = NULL,
  colDataColumns = NULL,
  infoColumns = NULL,
  rowDataOnDisk = TRUE,
  colDataOnDisk = TRUE
)

makeVariantExperimentFromSNPGDS(
  file,
  ftnode = "snp.id",
  smpnode = "sample.id",
  assayNames = NULL,
  rowDataColumns = NULL,
  colDataColumns = NULL,
  rowDataOnDisk = TRUE,
  colDataOnDisk = TRUE
)
}
\arguments{
\item{file}{the GDS file name to be converted.}

\item{ftnode}{the node name for feature id (e.g., "variant.id",
"snp.id", etc.).}

\item{smpnode}{the node name for sample id (e.g., "sample.id").}

\item{assayNames}{the gds node name that will be read into the
\code{assays} slot and be represented as \code{DelayedArray}
object.}

\item{rowDataColumns}{which columns of \code{rowData} to
import. The default is NULL to read in all variant annotation
info.}

\item{colDataColumns}{which columns of \code{colData} to
import. The default is NULL to read in all sample related
annotation info.}

\item{rowDataOnDisk}{whether to save the \code{rowData} as
DelayedArray object. The default is TRUE.}

\item{colDataOnDisk}{whether to save the \code{colData} as
DelayedArray object. The default is TRUE.}

\item{infoColumns}{which columns of \code{infoColumns} to import
for "SEQ_ARRAY" ("SeqVarGDSClass" gds class). The default is
NULL to read in all available info columns.}
}
\value{
An \code{VariantExperiment} object.
}
\description{
Conversion of gds files into SummarizedExperiment object.
}
\examples{

## gds file from DNA-seq data

seqfile <- SeqArray::seqExampleFileName(type="gds")
ve <- makeVariantExperimentFromGDS(seqfile)
## all assay data
names(assays(ve))
showAvailable(seqfile)

## only read specific columns for feature / sample annotation. 

assayNamess <- showAvailable(seqfile)$assayNames
rowdatacols <- showAvailable(seqfile)$rowDataColumns
coldatacols <- showAvailable(seqfile)$colDataColumns
infocols <- showAvailable(seqfile)$infoColumns
ve1 <- makeVariantExperimentFromGDS(
seqfile,
assayNames = assayNamess[2],
rowDataColumns = rowdatacols[1:3],
colDataColumns = coldatacols[1],
infoColumns = infocols[c(1,3,5,7)],
rowDataOnDisk = FALSE,
colDataOnDisk = FALSE)
assay(ve1)

## the rowData(ve1) and colData(ve1) are now in DataFrame format 

rowData(ve1)
colData(ve1)

## gds file from genotyping data

snpfile <- SNPRelate::snpgdsExampleFileName()
ve <- makeVariantExperimentFromGDS(snpfile)
rowData(ve)
colData(ve)
metadata(ve)

## Only read specific columns for feature annotation.

showAvailable(snpfile)
ve1 <- makeVariantExperimentFromGDS(snpfile, rowDataColumns=c("snp.allele"))
rowRanges(ve1)

## use specific conversion functions for certain gds types

veseq <- makeVariantExperimentFromSEQGDS(seqfile)
vesnp <- makeVariantExperimentFromSNPGDS(snpfile)
}
