% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-SnpArrayExperiment.R
\name{sweepMode}
\alias{sweepMode}
\alias{sweepMode,SnpArrayExperiment-method}
\title{Sweep the modal log R ratio (by row or column) from a matrix of log
R ratios}
\usage{
sweepMode(x, MARGIN)

\S4method{sweepMode}{SnpArrayExperiment}(x, MARGIN)
}
\arguments{
\item{x}{see \code{showMethods(sweepMode)}}

\item{MARGIN}{integer indicating which margin (1=rows, 2=columns)
to sweep the mode}
}
\value{
an object of the same class as \code{x}
}
\description{
This function simplifies the process of sweeping the modal log R
ratio from the rows or columns of a \code{SnpArrayExperiment}
object.  It is most useful when a large number of samples (more
than 10) are available and the dataset is a collection of germline
samples.  We assume that the samples are from a single batch and
that the modal value will be a robust estimate of the mean log R
ratio for diploid copy number.  Variation in the modal estimates
between markers is presumed to be attributable to probe effects
(e.g., differences hybridization efficiency/PCR do to sequence
composition). For sex chromosomes, one should apply this function
separately to men and women and then recenter the resulting matrix
according to the expected copy number.
}
\examples{
data(snp_exp)
snp_exp_rowcentered <- sweepMode(snp_exp, 1)
snp_exp_colcentered <- sweepMode(snp_exp, 2)
x <- lrr(snp_exp)
x_rowcentered <- sweep(x, 1, rowModes(x))
all.equal(lrr(snp_exp_rowcentered), x_rowcentered)
}
