% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ArrayViews.R
\name{dropDuplicatedMapLocs}
\alias{dropDuplicatedMapLocs}
\title{Drop markers on the same chromosome having the same genomic
coordinates}
\usage{
dropDuplicatedMapLocs(object)
}
\arguments{
\item{object}{a container for which the methods seqnames and start
are defined}
}
\value{
an object of the same class with duplicated genomic positions removed
}
\description{
If there are multiple markers on the same chromosome with the same
annotated position, only the first is kept.
}
\examples{
data(snp_exp)
g <- rowRanges(snp_exp)
## duplicate the first row
g[length(g)] <- g[1]
 rowRanges(snp_exp) <- g
 snp_exp2 <- dropDuplicatedMapLocs(snp_exp)
}
