% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-ArrayViews.R
\docType{class}
\name{ArrayViews-class}
\alias{ArrayViews-class}
\alias{'[',ArrayViews,ANY-method}
\alias{baf_means,ArrayViews-method}
\alias{ArrayViews}
\alias{[,ArrayViews,ANY,ANY,ANY-method}
\alias{ArrayViews,numeric,numeric-method}
\alias{"[",ArrayViews,ANY-method}
\alias{colnames<-}
\alias{colnames<-,ArrayViews,character-method}
\alias{colnames,ArrayViews-method}
\alias{colnames}
\alias{$,ArrayViews-method}
\alias{$<-,ArrayViews-method}
\alias{show,ArrayViews-method}
\alias{sapply,ArrayViews-method}
\alias{ncol,ArrayViews-method}
\alias{nrow,ArrayViews-method}
\alias{dim,ArrayViews-method}
\alias{start,ArrayViews-method}
\title{ArrayViews class, constructor, and methods}
\usage{
ArrayViews(
  class = "ArrayViews",
  colData,
  rowRanges = GRanges(),
  sourcePaths = character(),
  scale = 1000,
  sample_ids,
  parsedPath = getwd(),
  lrrFiles = character(),
  bafFiles = character(),
  gtFiles = character()
)

\S4method{[}{ArrayViews,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

colnames(x) <- value

\S4method{colnames}{ArrayViews}(x, do.NULL = TRUE, prefix = "col")

\S4method{$}{ArrayViews}(x, name)

\S4method{$}{ArrayViews}(x, name) <- value

\S4method{show}{ArrayViews}(object)

\S4method{sapply}{ArrayViews}(X, FUN, ..., simplify = TRUE, USE.NAMES = TRUE)

\S4method{ncol}{ArrayViews}(x)

\S4method{nrow}{ArrayViews}(x)

\S4method{dim}{ArrayViews}(x)

\S4method{start}{ArrayViews}(x)
}
\arguments{
\item{class}{character string}

\item{colData}{DataFrame}

\item{rowRanges}{GRanges object}

\item{sourcePaths}{character string provide complete path to plain text source files (one file per sample) containing log R ratios and B allele frequencies}

\item{scale}{log R ratios and B allele frequencies can be stored as integers on disk to increase IO speed.   If scale =1, the raw data is not transformed.  If scale = 1000 (default), the log R ratios and BAFs are multipled by 1000 and coerced to an integer.}

\item{sample_ids}{character vector indicating how to name samples.  Ignored if colData is specified.}

\item{parsedPath}{character vector indicating where parsed files
should be saved}

\item{lrrFiles}{character vector of file names for storing log R ratios}

\item{bafFiles}{character vector of file names for storing BAFs}

\item{gtFiles}{character vector of file names for storing genotypes}

\item{x}{a \code{ArrayViews} object}

\item{i}{numeric vector or missing}

\item{j}{numeric vector or missing}

\item{...}{additional arguments to \code{FUN}}

\item{drop}{ignored}

\item{value}{a character-string vector}

\item{do.NULL}{ignored}

\item{prefix}{ignored}

\item{name}{character string indicating name in colData slot of
ArrayViews object}

\item{object}{a \code{ArrayViews} object}

\item{X}{a \code{ArrayViews} object}

\item{FUN}{a function to apply to each column of \code{X}}

\item{simplify}{logical indicating whether result should be simplied}

\item{USE.NAMES}{whether the output should be a named vector}
}
\description{
ArrayViews provides views to the low-level data -- log R ratios, B
allele frequencies, and genotypes that are stored in parsed files
on disk, often scaled and coerced to an integer.  Accessors to the
low-level data are provided that extract the marker-level summaries
from disk, rescaling when appropriate.
}
\section{Slots}{

\describe{
\item{\code{colData}}{A character string}

\item{\code{rowRanges}}{A \code{DataFrame}. WARNING: The accessor for this slot is \code{rowRanges}, not \code{rowRanges}!}

\item{\code{index}}{A \code{GRanges} object}

\item{\code{sourcePaths}}{A character string providing complete path to source files (one file per sample) containing low-level summaries (Log R ratios, B allele frequencies, genotypes)}

\item{\code{scale}}{A length-one numeric vector}

\item{\code{parsedPath}}{A character string providing full path to where
parsed files should be saved}

\item{\code{lrrFiles}}{character vector of filenames for log R ratios}

\item{\code{bafFiles}}{character vector of filenames for BAFs}

\item{\code{gtFiles}}{character vector of filenames for genotypes}
}}

\examples{
ArrayViews()
## From unit test
  require(BSgenome.Hsapiens.UCSC.hg18)
  require(data.table)
  extdir <- system.file("extdata", package="VanillaICE", mustWork=TRUE)
  features <- suppressWarnings(fread(file.path(extdir, "SNP_info.csv")))
  fgr <- GRanges(paste0("chr", features$Chr), IRanges(features$Position, width=1),
                 isSnp=features[["Intensity Only"]]==0)
  fgr <- SnpGRanges(fgr)
  names(fgr) <- features[["Name"]]
  bsgenome <- BSgenome.Hsapiens.UCSC.hg18
  seqlevels(fgr, pruning.mode="coarse") <- seqlevels(bsgenome)[seqlevels(bsgenome) \%in\% seqlevels(fgr)]
  seqinfo(fgr) <- seqinfo(bsgenome)[seqlevels(fgr),]
  fgr <- sort(fgr)
  files <- list.files(extdir, full.names=TRUE, recursive=TRUE, pattern="FinalReport")
  ids <- gsub(".rds", "", gsub("FinalReport", "", basename(files)))
  views <- ArrayViews(rowRanges=fgr,
                      sourcePaths=files,
                      sample_ids=ids)
  lrrFile(views)
  ## view of first 10 markers and samples 3 and 5
  views <- views[1:10, c(3,5)]
}
\seealso{
\code{\link{CopyNumScanParams}} \code{\link{parseSourceFile}}
}
