% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spliceGene.R
\name{spliceGene}
\alias{spliceGene}
\title{Calculate Splicing Scores for One Gene}
\usage{
spliceGene(bg, gene, samples = sampleNames(bg), junc.type = c("score", "count"),
            trans.select = "rowMaxs(x)>=1", junc.select = "rowMaxs(x)>=5")
}
\arguments{
\item{bg}{ballgown object}

\item{gene}{a character string specifying gene id}

\item{samples}{names of samples}

\item{junc.type}{type of junction estimate ('score' for junction score;
'count' for junction read count)}

\item{trans.select}{logical expression-like string, indicating transcript
rows to select from a matrix of transcript coverages: NA value keeps all
transcripts. e.g. use trans.select='rowMaxs(x)>=1' to filter the transcrpts
with the maximium coverage among all the samples less than 1.}

\item{junc.select}{logical expression-like string, indicating junction rows
to select from a matrix of junction counts: NA value keeps all junctions.
e.g. use junc.select='rowMaxs(x)>=5' to filter the junctions with the
maximium read count among all the samples less than 5.}
}
\value{
a matrix of junction scores with intron rows and sample columns.
}
\description{
Calculate splicing Scores from ballgown object for a given gene.
This function can only calculate one gene. Please use function
\code{\link{spliceGenome}} to obtain genome-wide splicing scores.
}
\details{
score = junction count/gene-level per base read coverage.
Row functions for matrices are useful to select transcripts and junctions.
See \code{\link{matrixStats}} package.
}
\examples{
data(rice.bg)
rice.bg
head(geneIDs(rice.bg))

score<-spliceGene(rice.bg,'MSTRG.183',junc.type='score')
count<-spliceGene(rice.bg,'MSTRG.183',junc.type='count')

## compare
tail(score)
tail(count)

## get intron structrue
intron<-structure(rice.bg)$intron
intron[intron$id\%in\%rownames(score)]

}
\references{
Yu, H., Du, Q., Campbell, M., Yu, B., Walia, H. and Zhang, C. (2021), 
Genome‐wide discovery of natural variation in pre‐mRNA splicing and prioritising
causal alternative splicing to salt stress response in rice. 
New Phytol. \url{https://doi.org/10.1111/nph.17189}
}
\seealso{
\code{\link{spliceGenome}}, which calculates splicing scores in
whole genome.
}
